<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Auth;

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/test', function () {
    return view('test');
}) -> name('test');

Route::get('/', function () {
    return view('home');
}) -> name('home');

Route::get('/loading', function () {
    return view('loading');
}) -> name('loading');

Route::get('/email/verify', function () {
    return view('auth.verify-email');
})->middleware('auth')->name('verification.notice');

Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
    if ($request->hasValidSignature()) {    }
    $request->fulfill();
    return redirect('/');
})->middleware(['auth'/*, 'signed'*/])->name('verification.verify');

Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();
    return true;
    //return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.send');


Route::group(['middleware' => 'guest'], function(){
    
    Route::get('/register', [UserController::class, 'create']) -> name('register.create');
    Route::post('/register', [UserController::class, 'store']) -> name('register.store');
    Route::get('/login', [UserController::class, 'loginAuth']) -> name('login.auth');
    Route::post('/login', [UserController::class, 'login']) -> name('login');

    //Auth Google
    Route::get('/login/google', function () {
        return Socialite::driver('google')->redirect();
    }) -> name('login.google');
    Route::get('/login/google/callback', [UserController::class, 'loginGoogle']);

    //Auth Apple
    Route::get('login/apple', function () {
        return Socialite::driver('apple')->redirect();
    }) -> name('login.apple');
    Route::post('/login/apple/callback', [UserController::class, 'loginApple']);
});


Route::group(['middleware' => 'auth'], function(){
    Route::get('/logout', [UserController::class, 'logout']) -> name('logout');
    Route::get('/settings', [UserController::class, 'settings']) -> name('settings');
    Route::post('/settings', [UserController::class, 'edit']) -> name('settings.edit');
});

