<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Route;
use Laravel\Socialite\Facades\Socialite;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::get('/test', function () {
    return view('test');
});

Route::get('/', function () {
    return view('home');
}) -> name('home');

Route::get('/loading', function () {
    return view('loading');
}) -> name('loading');

Route::group(['middleware' => 'guest'], function(){
    
    Route::get('/register', [UserController::class, 'create']) -> name('register.create');
    Route::post('/register', [UserController::class, 'store']) -> name('register.store');
    Route::get('/login', [UserController::class, 'loginAuth']) -> name('login.auth');
    //Route::get('/login', [UserController::class, 'loginForm']) -> name('login.create');
    Route::post('/login', [UserController::class, 'login']) -> name('login');

    //Auth Google
    Route::get('/login/google', function () {
        return Socialite::driver('google')->redirect();
    }) -> name('login.google');
    Route::get('/login/google/callback', [UserController::class, 'loginGoogle']);

    //Auth Apple
    Route::get('login/apple', function () {
        return Socialite::driver('apple')->redirect();
        //return Socialite::driver("sign-in-with-apple")->scopes(["name", "email"])->redirect();
    }) -> name('login.apple');
    Route::post('/login/apple/callback', [UserController::class, 'loginApple']);
});

Route::group(['middleware' => 'auth'], function(){

    Route::get('/logout', [UserController::class, 'logout']) -> name('logout');
    Route::get('/settings', [UserController::class, 'settings']) -> name('settings');
    Route::post('/settings', [UserController::class, 'edit']) -> name('settings.edit');
    
});

