@extends('layouts.layout')

@section('title')Авторизацiя @endsection

@section('page_scripts')
    @if(!config('project.minificate_static'))
        <script src="assets/js/login.js"></script>
    @endif
@endsection


@section('content')

<section>
    <div class='container'>

        <div class="row justify-content-center">
            <div class="col-4 text-center">

                <h4>Авторизацiя</h4>

                <form method="post" action="{{ route('login') }}">

                    @csrf

                    <div class="form-group">
                        <label for='email'>Email address</label>
                        <input class="form-control" type="email" id="email" name="email" value="{{ old('email') }}">
                    </div>

                    <div class="form-group">
                        <label for='password'>Password</label>
                        <input class="form-control" type="password" id="password" name="password">
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Войти</button>
                    </div>

                    <a class="btn btn-google" href="{{ route('login.google') }}"><img src="https://img.icons8.com/color/16/000000/google-logo.png"> Sign in with Google</a>
                    
                    <div>
                        @signInWithApple("black", true, "sign-in", 10)
                    </div>

                </form>

            </div>
        </div>

    </div>
</section>


@endsection  

