(function() {
    "use strict";


    const select = (el, all = false) => {
    el = el.trim()
    if (all) {
      return [...document.querySelectorAll(el)]
    } else {
      return document.querySelector(el)
    }
    }

    const on = (type, el, listener, all = false) => {
    let selectEl = select(el, all)
    if (selectEl) {
      if (all) {
        selectEl.forEach(e => e.addEventListener(type, listener))
      } else {
        selectEl.addEventListener(type, listener)
      }
    }
    }


    let
        social = select('.b-social'),
        auth = select('.b-auth'),
        email = select('.b-email'),
        reg = select('.b-reg'),
        authTitle = select('.modal-title.auth'),
        regTitle = select('.modal-title.reg');
        
    function ToggleLoginBlock()
    {
        email.classList.toggle('m-hide');
        reg.classList.toggle('m-hide');
        authTitle.classList.toggle('m-hide');
        regTitle.classList.toggle('m-hide');
    }

    function ToggleAuthBlock()
    {
        social.classList.toggle('m-hide');
        auth.classList.toggle('m-hide');
    }
    
    on('click', '.btn-email', function(e) {
        e.preventDefault();
        ToggleAuthBlock();
    });

    on('click', '.soc-link', function(e) {
        e.preventDefault();
        ToggleAuthBlock();
    });
    
    on('click', '.soc-link2', function(e) {
        e.preventDefault();
        ToggleAuthBlock();
    });

    on('click', '.auth-link', function(e) {
        e.preventDefault();
        ToggleLoginBlock();
    });

    on('click', '.reg-link', function(e) {
        e.preventDefault();
        ToggleLoginBlock();
    });
    

})();


(function() {

    var constraintsAuth = {
        email: {
            presence: {message: "Email не повинен бути пустим"},
            email: {message: "Перевiрте поштову адресу"}
        },
        password: {
            presence: {message: "Пароль не повинен бути пустим"},
        },
    };
    
    
    
    var constraintsReg = {
        email: {
            presence: {message: "Email не повинен бути пустим"},
            email: {message: "Перевiрте поштову адресу"}
        },
        password: {
            presence: {message: "Пароль не повинен бути пустим"},
        },
        'password_confirmation': {
            presence: {message: "Повторiть пароль"},
            equality: {
                attribute: "password",
                message: "Паролi не спiвпадають"
            }
        },
    };

    var alertForm = document.querySelector(".b-alerts .alert.form");
    var alertAll = document.querySelectorAll(".b-alerts .alert");
    
    // клик извне, чтобы закрыть сообщение ошибок
    document.addEventListener( 'click', (e) => {
        const withinAlertAll = e.composedPath().includes(alertAll);
            if (!withinAlertAll) {
                //alertAll.classList.add('m-hide');
                alertAll.forEach(function(item){
                    item.classList.add('m-hide');
                })
            }
    });
    
    
    var formAuth = document.querySelector("form#auth-form");
    formAuth.addEventListener("submit", function(ev) {
        ev.preventDefault();
        handleFormSubmit(formAuth, constraintsAuth);
    });
    
    
    var formReg = document.querySelector("form#reg-form");
    formReg.addEventListener("submit", function(ev) {
        ev.preventDefault();
        handleFormSubmit(formReg, constraintsReg);
    });
    
    var formSet = document.querySelector("form#set-form");
    if (formSet) {
        formSet.addEventListener("submit", function(ev) {
            ev.preventDefault();
            handleFormSubmit(formSet, constraintsReg);
        });
    }
    

    function handleFormSubmit(form, constraints) {
        var errors = validate(form, constraints, {fullMessages: false});
        showErrors(errors || {});
        if (!errors) {
            form.submit();
        }
    }


    function showErrors(errors) {
        if (!Object.keys(errors).length) {
            return false;
        }
        
        var messageText = '<ul>';
        for (const [key, value] of Object.entries(errors)) {
            messageText += `<li>${value}</li>`;
        }
        messageText += '</ul>';
        alertForm.innerHTML = messageText;
        alertForm.classList.remove('m-hide');
    }

      
})();