<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

use Illuminate\Auth\Notifications\VerifyEmail;
use Illuminate\Notifications\Messages\MailMessage;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        //
        VerifyEmail::toMailUsing(function ($notifiable, $url) {
            
            return (new MailMessage)
                ->view('auth.verify-email', ['url' => $url])
                ->subject('Підтвердьте адресу електронної пошти');
            
            /*
            return (new MailMessage)
                ->greeting('Вітаємо!')
                ->subject('Підтвердьте адресу електронної пошти')
                ->line('Натисніть кнопку нижче, щоб підтвердити свою електронну адресу.')
                ->action('Підтвердити Email', $url);
            */
        });
    }
}
