<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Auth\Middleware\EnsureEmailIsVerified as Middleware;
use Illuminate\Http\Request;


class EnsureEmailIsVerified extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    public static function redirectTo($route)
    {
        return static::class.':'.$route;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $redirectToRoute
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse|null
     */
    public function handle($request, Closure $next, $redirectToRoute = null)
    {
        if (! $request->user() ) {
            return redirect()->route('home');
        } else {
            if (! $request->user()->hasVerifiedEmail()) {
                return redirect()->route('home');
            }
        }

        return $next($request);
    }
    
}
