<?php

namespace App\Http\Controllers;

use App\Models\User;
//use App\Mail\AuthMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Auth\Events\Registered;
use Laravel\Socialite\Facades\Socialite;



class UserController extends Controller
{
    // GET
    
    public function create() {
        return view('user.create');
    }
    
    public function loginAuth() {
        $is_auth = true;
        return view('user.auth', compact('is_auth'));
    }
    
    public function logout(Request $request) {
        Auth::logout();
        return redirect()->route('home');
    }
    
    public function settings() {
        return view('user.settings');
    }
    
    
    // POST
    
    public function store(Request $request) {
        
        $request->validate([
            'email' => 'required|email|unique:users',
            'password' => 'required|confirmed',
        ],
        [
            'email.unique' => 'Email вже використовується.',
        ]);
        
        //Mail::to($request->email)->send(new AuthMail());
        
        
        $user = User::create([
            'email' => $request->email,
            'password' => Hash::make($request->password),
        ]);
        
        event(new Registered($user));
        
        Auth::login($user);
        
        return response()->json([
            'status' => 'email_send',
            'email' => $request->email,
            'link' => '/email/verification-notification',
        ]);
        
        /*
        session()->flash('success', 'Реєстрація успішна');
        Auth::login($user);
        
        return response()->json([
            'status' => 'success',
            'redirect' => route('home')
        ]);
        */
    }
    
    public function edit(Request $request) {
        //dd($request->all());
        
        $request->validate([
            'email' => 'required|email',
            'password' => 'required|confirmed',
        ]);
        
        $user = Auth()->user();
        
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        
        if ($user->save()) {
            session()->flash('success', 'Налаштування збережено успішно');
            return response()->json([
                'status' => 'success',
                'redirect' => route('settings')
            ]);
        }
        //return redirect()->back()->with('error', 'Виникла помилка при збереженні налаштувань');
        return response()->json([
            'status' => 'error',
            'message' => 'Виникла помилка при збереженні налаштувань'
        ]);

    }
    
    public function login(Request $request) {
        
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        
        if (Auth::attempt([
            'email' => $request->email,
            'password' => $request->password,
        ])) {
            return response()->json([
                'status' => 'success',
                'redirect' => route('home')
            ]);
        }
        return response()->json([
            'status' => 'error',
            'message' => 'Введено невiрний Email або пароль'
        ]);

    }
    
    public function loginGoogle() {
        $googleUser = Socialite::driver('google')->user();

        $user = User::where('email','=', $googleUser->email)->first();
        if (!$user) {
            $user = User::create([
                'email' => $googleUser->email,
                'password' => Hash::make(config('project.empty_password')),
            ]);
            $user->email_verified_at = NOW();
            $user->save();
        }

        Auth::login($user);
        return redirect()->route('loading');
    }
    
    public function loginApple() {
        $appleUser = Socialite::driver('apple')->user();
        //$appleUser = Socialite::driver("sign-in-with-apple")->user();
        
        $user = User::where('email','=', $appleUser->email)->first();
        if (!$user) {
            $user = User::create([
                'email' => $appleUser->email,
                'password' => Hash::make(config('project.empty_password')),
                
            ]);
            $user->email_verified_at = NOW();
            $user->save();
        }

        Auth::login($user);
        return redirect()->route('loading');
    }
    
}
