<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Laravel\Socialite\Facades\Socialite;

class UserController extends Controller
{
    public function create() {
        
        return view('user.create');
    }
    
    public function store(Request $request) {
        //dd($request->all());
        
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users',
            'password' => 'required|confirmed',
        ]);
        
        $user = User::create([
            'name' => $request->name, // || 'name' => $request->input('name'),
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'email_verified_at' => NOW(),
        ]);
        
        session()->flash('success', 'Successful registration');
        Auth::login($user);
        return redirect()->route('home'); // || redirect()->home(); || redirect('/');
    }
    
    public function edit(Request $request) {
        //dd($request->all());
        
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed',
        ]);
        
        $user = Auth()->user();
        
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->email_verified_at = NOW();
        
        if ($user->save()) {
            session()->flash('success', 'Sittings saved successful');
            return redirect()->back();
        }
        return redirect()->back()->with('error', 'Sittings saving error');
    }
    
    public function loginForm() {
        return view('user.login');
    }
    
    public function login(Request $request) {
        
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        
        if (Auth::attempt([
            'email' => $request->email,
            'password' => $request->password,
        ])) {
            return redirect()->route('home');
        }
        return redirect()->back()->with('error', 'Incorrect login or password');
    }
    
    public function logout(Request $request) {
        Auth::logout();
        return redirect()->route('login.create');
    }
    
    public function settings() {
        return view('user.settings');
    }
    
    public function loginGoogle() {
        $googleUser = Socialite::driver('google')->user();

        $user = User::where('email','=', $googleUser->email)->first();
        if (!$user) {
            $user = User::create([
                'name' => $googleUser->name,
                'email' => $googleUser->email,
                'password' => Hash::make(config('project.empty_password')),
            ]);
        }

        Auth::login($user);
        return redirect()->route('home');
    }
    
    public function loginApple() {
        $appleUser = Socialite::driver('apple')->user();
        //$appleUser = Socialite::driver("sign-in-with-apple")->user();
        
        $user = User::where('email','=', $appleUser->email)->first();
        if (!$user) {
            $user = User::create([
                'name' => $googleUser->name,
                'email' => $googleUser->email,
                'password' => Hash::make(config('project.empty_password')),
            ]);
        }

        Auth::login($user);
        return redirect()->route('home');
    }
    
    
    
}
