@extends('layouts.layout')

@section('title')Авторизацiя @endsection

@section('page_scripts')
    @if(!config('project.minificate_static'))
        <script src="assets/js/login.js"></script>
    @endif
@endsection


@section('content')

<section>
    <div class='container'>
        
        <div class="b-auth-wrap d-flex row align-items-center justify-content-center">

            <div>

                <div class="text-center">
                    <h4>Авторизацiя</h4>
                </div>

                <div class="b-social row justify-content-center">
                    <div class="col-12 col-sm-10 col-lg-6 text-center">

                        <div>
                            <div class="row">
                                <a class="btn btn-google" href="{{ route('login.google') }}" role="button"><img src="https://img.icons8.com/color/16/000000/google-logo.png"> Sign in with Google</a>
                            </div>
                            <br>
                            <div class="row b-social_apple">
                                @signInWithApple("white", true, "sign-in", 10)
                            </div>
                            <br>
                            <div class="row">
                                <a class="btn btn-email" href="#" role="button">Продовжити за допомогою e-mail</a>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="b-email row justify-content-center m-hide">
                    <div class="col-12 col-sm-10 col-lg-6 text-center">

                        <form method="post" action="{{ route('login') }}">

                            @csrf

                            <div class="form-group">
                                <label for='email'>Email address</label>
                                <input class="form-control" type="email" id="email" name="email" value="{{ old('email') }}">
                            </div>

                            <div class="form-group">
                                <label for='password'>Password</label>
                                <input class="form-control" type="password" id="password" name="password">
                            </div>
                            <br>
                            <div class="form-group d-flex justify-content-between">
                                <a class="b-email_back" href="#">Назад</a>
                                <button type="submit" class="btn btn-primary">Войти</button>
                            </div>
                        </form>

                    </div>
                </div>

            </div>
            
        </div>
            
    </div>
</section>


@endsection  

