$(document).ready(function(){

    var 
        $body = $('body'),
        $foldersContentWrap = $('.b-preview'),
        $loading = $('.b-loading'),
        colorsActive = $foldersContentWrap.data('colors'),
        freeNumbers = [1,2,3,4,5],
        pairsCount = $foldersContentWrap.data('pairs_count'),
        currentNumToSelect = {},
        hasSelectedFoto = {};
    
    function StartLoading()
    {
        $loading.show();
    }
    
    function StopLoading()
    {
        $loading.hide();
    }
    
    function MarkFolderSelected($folderName)
    {
        $('.b-list_folders-item').removeClass('active');
        $folderName.addClass('active');
    }
    
    function MarkFolderViewed($folderName)
    {
        $folderName.addClass('viewed');
    }
    
    function RenderFilesList(folderName, data)
    {
        // Добавляем содержимое папки:
        var templateFolderContent = _.template('' +
            '<div class="b-folder-content row active" data-folder="<%= folder %>">' +
            '   <% _.each(files, function(item) { %>   \n' +
            '    <div class="b-foto col-<%= cols %> order-12" data-id="<%= item %>">' +
            '       <div class="b-foto_inner" style="background-image: url(/fotos/<%= folder %>/<%= item %>)" data-foto="<%= item %>" data-num="">' +
            '       <div class="b-foto_number"></div>' +
            '       ' +
            '       </div>' +
            '    </div>' +
            '   <% }) %>  \n' +
            '</div>'
        );

        var cols;
        
        switch (data.length) {
            case 4:
                cols = 6;
                break;
            case 5:
            case 6:
                cols = 4;
                break;
            case 7:
            case 8:
                cols = 3;
                break;
            case 9:
            case 10:
                cols = 2;
                break;
            default:
              cols = 4;
        }

        $foldersContentWrap.append(templateFolderContent({folder: folderName, files: data, cols: cols}));
        currentNumToSelect[folderName] = 1;
        hasSelectedFoto[folderName] = false; // Выбрали одну картинку (есть подсвеченное фото)
    }
    
    function getCurrenNumToSelect($folderWrap)
    {
        for (let n = 1; n <= pairsCount; n++) {
            if ($('.b-foto_inner[data-num="' + n + '"]', $folderWrap).length == 0) return n;
        }
    }
    
    function SetCountPairedInFolderItemList(folderName)
    {
        var pairsCount = currentNumToSelect[folderName]-1;
        $('.b-list_folders-item[data-folder="' + folderName + '"] b').text((pairsCount == 0) ? '' : pairsCount);
        
        //var $folderContent = $('.b-folder-content[data-folder="' + folderName + '"]');
        
        
    }
    
    // Клик на папку для загрузки фотографий:
    $('.b-list_folders-item').on('click', function(){
        
        var
            $this = $(this),
            $foldersContent = $('.b-folder-content'),
            $form = $('#load-folder-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            folderName = $(this).data('folder'),
            data = {
                folder: folderName
            };
            
        $foldersContent.hide().removeClass('active');
       
        if ($('.b-folder-content[data-folder="' + folderName + '"]').length>0) {
            console.log('AAA отображаем');
            $('.b-folder-content[data-folder="' + folderName + '"]').show().addClass('active');
            MarkFolderSelected($this);
        } else {
            console.log('AAA подгружаем');
            StartLoading();
            $.ajax(action, {
                type: method,
                data: data,
                success: function(data) {
                    //console.log('AAA success', data);
                    StopLoading();
                    RenderFilesList(folderName, data);
                    MarkFolderSelected($this);
                    MarkFolderViewed($this);
                },
                error: function(rew, status, err) {
                    console.log(status, err);                    
                }
            });
        }
       
        return false; 
    });
    
    // Клик на фото:
    $foldersContentWrap.on('click', '.b-foto_inner', function(){
        
        var
            $this = $(this),
            num,
            $currentFolderWrap = $this.parents('.b-folder-content'),
            folderName = $currentFolderWrap.data('folder'),
            $pairedFoto,
            fadeDuration = 100;
        
        if (!$this.hasClass('selected'))
        {
            // Клик по фото без рамки
            
            if (!hasSelectedFoto[folderName]) {
                // выбор первого фото для пары:
                console.log('AAA 1-е фото в пару');
                num = currentNumToSelect[folderName];
                hasSelectedFoto[folderName] = true;
                $currentFolderWrap.addClass('has-selected');
                
                
            } else {
                // выбор второго фото для пары (пара сформирована):
                console.log('AAA 2-е фото в пару');
                num = currentNumToSelect[folderName];
                $pairedFoto = $('.b-foto_inner[data-num="' + num + '"]', $currentFolderWrap);
                $this.addClass('paired');
                $pairedFoto.addClass('paired');
                
                
                $this.fadeOut(fadeDuration, function() {
                    $this.parent('.b-foto').removeClass('order-12').addClass('order-' + num);
                    $this.fadeIn(fadeDuration);
                });
                $pairedFoto.fadeOut(fadeDuration, function() {
                    $pairedFoto.parent('.b-foto').removeClass('order-12').addClass('order-' + num);
                    $pairedFoto.fadeIn(fadeDuration);
                });
                /*
                $pairedFoto.parent('.b-foto').removeClass('order-12').addClass('order-' + num);
                $this.parent('.b-foto').removeClass('order-12').addClass('order-' + num);
                */
                
                currentNumToSelect[folderName] = getCurrenNumToSelect($currentFolderWrap);
                hasSelectedFoto[folderName] = false;
                $currentFolderWrap.removeClass('has-selected');
                
            }
            
            $('.b-foto_number', $this).text(num);
            $this.attr('data-num', num);
            $this.css('border-color', colorsActive[num]);
            $this.addClass('selected');
            
            // Если осталось одно неразмеченное фото, то выбираем и его автоматически:
            if (hasSelectedFoto[folderName]) {
                var notSelectedFotos = $('.b-foto_inner:not(.selected)', $currentFolderWrap);
                if (notSelectedFotos.length == 1) {
                    notSelectedFotos.click();
                }
            }
            
        }
        else
        {
            // Клик по фото с рамкой
            console.log('AAA Клик по фото с рамкой');
            
            var
                pairedNum = $this.attr('data-num'),
                $pairedFotos = $('.b-foto_inner[data-num="' + pairedNum + '"]', $currentFolderWrap),
                isFromPair = $this.hasClass('paired');
            
            if (hasSelectedFoto[folderName] && isFromPair) {
                return false;
            }
            
            $pairedFotos.parent('.b-foto').removeClass('order-' + pairedNum).addClass('order-12');
            
            $('.b-foto_number', $pairedFotos).text('');
            $pairedFotos.attr('data-num', '')
                        .removeClass('paired')
                        .removeClass('selected')
                        .css('border-color', '#8D9094');
            
            hasSelectedFoto[folderName] = false;
            $currentFolderWrap.removeClass('has-selected');
            currentNumToSelect[folderName] = getCurrenNumToSelect($currentFolderWrap);
        }
        
        SetCountPairedInFolderItemList(folderName);
    });        

    // Обработка нажатия клавиш:
    $body.keyup(function(e) {
        
        // Пробел
        if (e.keyCode == 32)
        {
            var
                $activeFolder = $('.b-folder-content.active', $foldersContentWrap),
                $fotos = $('.b-foto_inner', $activeFolder);
                
            if ($fotos.length == 2) {
                $fotos.first().click();
            }
        }
        
        // Вниз
        if (e.keyCode == 40)
        {
            var
                $activeFolderItemList = $('.b-list_folders-item.active'),
                $nextFolderItem = $activeFolderItemList.next();
            
            $nextFolderItem.click();
        }
        
        // Вверх
        if (e.keyCode == 38)
        {
            var
                $activeFolderItemList = $('.b-list_folders-item.active'),
                $previousFolderItem = $activeFolderItemList.prev();
            
            $previousFolderItem.click();
        }
    
    });

    // Клик на "Сохранить" для объявления:
    $('.btn.btn-primary.save-folders').on('click', function(){
        
        var
            $form = $('#save-folders-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            data = {
                type: 213
            };

            data.test = 123;
       
        console.log('AAA data = ', data);
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                console.log('AAA success', data);
                /*
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                }
                */
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
        
    });        
    

    // Отображаем содержимое первой папки при загрузке страницы:
    $('.b-list_folders-item').first().click();

});