<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use App\Authentication\SupportService;
use App\Entity\Support;
use App\Model\Supports as SupportsModel;
use Monolog\Logger;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Hydrator\DelegatingHydrator;

/**
 * Class Profile
 * @package App\Action\Admin
 */
class Profile extends Common
{

    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        if ($request->getMethod() == 'POST') {
            
            $data = $request->getParsedBody();
            
            if (isset($data['currency'])) {
                setcookie('adminCurrency', $data['currency'], time()+3600*24*365, '/');
                $result = [
                    'result' => true,
                ];
                $response = new JsonResponse($result);
                return $response;
            }
            
            $oldPass = $newPass = false;
            if (isset($data['password'])) {
                $oldPass = $data['password'];
            }
            if (isset($data['new-password'])) {
                $newPass = $data['new-password'];
            }
            /** @var SupportService $auth */
            $auth = $this->container->get(SupportService::class);
            $identity = $auth->getIdentity();

            if (password_verify($oldPass, $identity->getPassword())) {
                if ($oldPass == $newPass) {
                    $result = [
                        'result' => false,
                        'msg' => _t('Старый и новый пароль совпадают'),
                    ];
                } else {
                    try {
                        /** @var SupportsModel $supportsModel */
                        $supportsModel = $this->container->get(SupportsModel::class);
                        $support = $supportsModel->findById($identity->getId());
                        /** @var DelegatingHydrator $hydrator */
                        $hydrator = $this->container->get(DelegatingHydrator::class);

                        $newPassData = ['password' => $supportsModel->hashPassword($newPass)];
                        $support = $hydrator->hydrate($newPassData, $support);

                        /** @noinspection PhpParamsInspection */
                        $result = $supportsModel->save($support);

                        $result = [
                            'result' => true,
                        ];
                    } catch (\Exception $e) {
                        /** @var Logger $log */
                        $log = $this->container->get(Logger::class);
                            $log->error($e->getMessage(), [
                                'trace' => $e->getTraceAsString()
                            ]);

                        $result = [
                            'result' => false,
                            'msg' => $e->getMessage(),
                        ];
                    }
                }
            } else {
                $result = [
                    'result' => false,
                    'msg' => _t('Пароль неверен'),
                ];
            }
            $response = new JsonResponse($result);
        } else {
            $response = new HtmlResponse($this->template->render('adm::profile', [
                'lang' => $request->getAttribute('layoutInfo')->getLang()
            ]));
        }
        return $response;
    }
}