<?php
use App\Acl\Roles;
use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'factories' => [
            \Zend\Permissions\Acl\AclInterface::class => function (ContainerInterface $container) {
                $acl = new \Zend\Permissions\Acl\Acl();
                foreach ($container->get('aclRoles') as $value) {
                    if (is_array($value)) {
                        $acl->addRole($value['role'], $value['parent']);
                    } else {
                        $acl->addRole($value);
                    }
                }
                foreach ($container->get('aclResources') as $resource) {
                    $acl->addResource($resource);
                }

                $acl->deny(null, null);
                    
                // Admin
                $acl->allow(Roles::ROLE_ADMIN, 'adm.pairs')
                    ->allow(Roles::ROLE_ADMIN, 'adm.index')
                ;

                return $acl;
            },
            'aclResources' => function (ContainerInterface $container) {
                $result = [];
                $routes = $container->get('config')['routes'];
                foreach ($routes as $route) {
                    $result[] = $route['name'];
                }
                return $result;
            },
            'aclRoles' => function () {
                return (new Roles())->getRoles();
            },
        ],
    ],
];
