$(document).ready(function(){

    var 
        $foldersContentWrap = $('.b-preview'),
        colorsActive = $foldersContentWrap.data('colors');
        
    function RenderFilesList(folderName, data)
    {
        // Добавляем содержимое папки:
        var templateFolderContent = _.template('' +
            '<div class="b-folder-content row" data-folder="<%= folder %>">' +
            '   <% _.each(files, function(item) { %>   \n' +
            '    <div class="b-foto col-4" data-id="<%= item %>">' +
            '       <div class="b-foto_inner" style="background-image: url(/fotos/<%= folder %>/<%= item %>)" data-foto="<%= item %>" data-num="">' +
            '       <div class="b-foto_number">1</div>' +
            '       ' +
            '       </div>' +
            '    </div>' +
            '   <% }) %>  \n' +
            '</div>'
        );

        $foldersContentWrap.append(templateFolderContent({folder: folderName, files: data}));
    }
    
    // Клик на папку для загрузки фотографий:
    $('.b-list_folders-item').on('click', function(){
        
        var
            $foldersContent = $('.b-folder-content'),
            $form = $('#load-folder-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            folderName = $(this).data('folder'),
            data = {
                folder: folderName
            };
       
        $foldersContent.hide();
       
        if ($('.b-folder-content[data-folder="' + folderName + '"]').length>0) {
            
            console.log('AAA отображаем');
            $('.b-folder-content[data-folder="' + folderName + '"]').show();
            
        } else {
            
            console.log('AAA подгружаем');
            
            $.ajax(action, {
                type: method,
                data: data,
                success: function(data) {
                    //console.log('AAA success', data);
                    RenderFilesList(folderName, data);
                },
                error: function(rew, status, err) {
                    console.log(status, err);                    
                }
            });
        }
       
       
        
        return false;
        
    });

    var
        currentNumToSelect = 1,
        freeNumbers = [1,2,3,4,5],
        hasSelectedFoto = false; // Выбрали одну картинку (есть подсвеченное фото)
    
    // Клик на фото:
    $foldersContentWrap.on('click', '.b-foto_inner', function(){
        
        var
            $this = $(this),
            num;
        
        if (!$this.hasClass('selected')) {
            // Клик по фото без рамки
            
            if (hasSelectedFoto) {
                // выбор второго фото для пары (пара сформирована):
                console.log('AAA 2-е фото в пару');
                num = currentNumToSelect;
                
                $this.addClass('paired');
                $('.b-foto_inner[data-num="' + num + '"]').addClass('paired');
                
                freeNumbers.some(function(el) {
                    currentNumToSelect = el;
                    return ($('.b-foto_inner[data-num="' + el + '"]').length == 0);
                });
                hasSelectedFoto = false;
            } else {
                // выбор первого фото для пары:
                console.log('AAA 1-е фото в пару');
                num = currentNumToSelect;
                hasSelectedFoto = true;
            }
            
            
            $('.b-foto_number', $this).text(num);
            $this.attr('data-num', num);
            $this.css('border-color', colorsActive[num]);
            $this.addClass('selected');
            
        } else {
            // Клик по фото с рамкой
            var
                pairedNum = $this.attr('data-num'),
                $pairedFotos = $('.b-foto_inner[data-num="' + pairedNum + '"]');
            
            /*
            $('.b-foto_number', $this).text('');
            $this.attr('data-num', '');
            $this.css('border-color', '#8D9094');
            $this.removeClass('selected');
            
            if (hasSelectedFoto) {
                // убираем фото без пары:
                console.log('AAA убираем 1-е фото из пары');
                
                if (pairedNum == currentNumToSelect) {
                    console.log('AAA фото без пары');
                    
                    freeNumbers.some(function(el) {
                        currentNumToSelect = el;
                        return ($('.b-foto_inner[data-num="' + el + '"]').length == 0);
                    });
                    hasSelectedFoto = false;
                    
                } else {
                    console.log('AAA фото из пары, но имеется подсвеченное другое');
                }
                
            } else {
                // Убираем фото из пары:
                console.log('AAA убираем 2-е фото из пары');
                hasSelectedFoto = true;
                
                currentNumToSelect = pairedNum;
                $('.b-foto_inner[data-num="' + pairedNum + '"]').removeClass('paired');
                $this.removeClass('paired');
            }
            */
           
            console.log('AAA убираем пару');
            hasSelectedFoto = false;
            
            $('.b-foto_number', $pairedFotos).text('');
            $pairedFotos.attr('data-num', '')
                        .removeClass('paired')
                        .removeClass('selected')
                        .css('border-color', '#8D9094');
            
            freeNumbers.some(function(el) {
                currentNumToSelect = el;
                return ($('.b-foto_inner[data-num="' + el + '"]').length == 0);
            });
            
            
        }
        
        
    });        

    // Клик на "Сохранить" для объявления:
    $('.btn.btn-primary.save-folders').on('click', function(){
        
        var
            $form = $('#save-folders-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            data = {
                type: 213
            };

            data.test = 123;
       
        console.log('AAA data = ', data);
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                console.log('AAA success', data);
                /*
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                }
                */
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
        
    });        
    

});