<?php

use Zend\Expressive\ZendView\ZendViewRenderer;
use Zend\View\Model\ViewModel;

return [
    'dependencies' => [
        'factories' => [
            'Zend\Expressive\FinalHandler' =>
                Zend\Expressive\Container\TemplatedErrorHandlerFactory::class,
            Zend\Expressive\Template\TemplateRendererInterface::class => function (\Interop\Container\ContainerInterface $container) {
                $class = \Zend\Expressive\ZendView\ZendViewRendererFactory::class;
                $factory = new $class;
                $layout = $container->get('layout');
                $container->get('config')['templates']['layout'] = $layout;
                /** @var ZendViewRenderer $renderer */
                $renderer = $factory($container);
                return $renderer;
            },

            'layout' => function () {
                // Create the layout view model
                $layout = new ViewModel([
                    'encoding' => 'utf-8',
                ]);
                $layout->setTemplate('empty');
                return $layout;
            },
            Zend\View\HelperPluginManager::class =>
                Zend\Expressive\ZendView\HelperPluginManagerFactory::class,
        ],
    ],
    'templates' => [
        'map' => [
            'empty'          => 'templates/layout/empty.phtml',
            'layout/iframe'  => 'templates/layout/iframe.phtml',
            'layout/default' => 'templates/layout/layout-main.phtml',
            'layout/support' => 'templates/layout/support.phtml',
            'error/error'    => 'templates/error/error.phtml',
            'error/404'      => 'templates/error/404.phtml',
        ],
        'paths' => [
            'app'    => ['templates/app'],
            'adm'    => ['templates/adm'],
            'download' => ['templates/download'],
            'layout' => ['templates/layout'],
            'error'  => ['templates/error'],
        ],
    ],

    'view_helpers' => [
        
    ],
];
