<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use App\Entity\Support;
use App\Model\Supports as SupportsModel;
use Monolog\Logger;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Hydrator\DelegatingHydrator;

/**
 * Class Init
 * @package App\Action\Admin
 */
class Init extends Common
{

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return JsonResponse
     * @throws \Exception
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        $data = $this->container->get('config')['admin'];

        /** @var SupportsModel $supportModel */
        $supportModel = $this->container->get(SupportsModel::class);
        /** @var DelegatingHydrator $hydrator */
        $hydrator = $this->container->get(DelegatingHydrator::class);

        $support = $supportModel->findAll();
        if ($support->count()) {
            throw new \Exception('Already initialized support');
        }
        try {
            $data['password'] = $supportModel->hashPassword($data['password']);

            $support = $hydrator->hydrate($data, new Support());

            /** @noinspection PhpParamsInspection */
            $result = $supportModel->save($support);

        } catch (\Exception $e) {
            /** @var Logger $log */
            $log = $this->container->get(Logger::class);
            $context = [
                'trace' => $e->getTraceAsString()
            ];
            if (!empty($e->getPrevious())) {
                $context['prev']['msg'] = $e->getPrevious()->getMessage();
                $context['prev']['trace'] = $e->getPrevious()->getTraceAsString();
            }
            $log->error($e->getMessage(), $context);
            $result = false;
        }

        return new JsonResponse(['register' => $result]);
    }
}