$(document).ready(function(){

    var 
        $foldersContentWrap = $('.b-preview'),
        $loading = $('.b-loading'),
        colorsActive = $foldersContentWrap.data('colors'),
        freeNumbers = [1,2,3,4,5],
        currentNumToSelect = {},
        hasSelectedFoto = {};
    
    function StartLoading()
    {
        $loading.show();
    }
    
    function StopLoading()
    {
        $loading.hide();
    }
    
    function MarkFolderSelected($folderName)
    {
        $('.b-list_folders-item').removeClass('selected');
        $folderName.addClass('selected');
    }
    
    function RenderFilesList(folderName, data)
    {
        // Добавляем содержимое папки:
        var templateFolderContent = _.template('' +
            '<div class="b-folder-content row" data-folder="<%= folder %>">' +
            '   <% _.each(files, function(item) { %>   \n' +
            '    <div class="b-foto col-4" data-id="<%= item %>">' +
            '       <div class="b-foto_inner" style="background-image: url(/fotos/<%= folder %>/<%= item %>)" data-foto="<%= item %>" data-num="">' +
            '       <div class="b-foto_number">1</div>' +
            '       ' +
            '       </div>' +
            '    </div>' +
            '   <% }) %>  \n' +
            '</div>'
        );

        $foldersContentWrap.append(templateFolderContent({folder: folderName, files: data}));
        currentNumToSelect[folderName] = 1;
        hasSelectedFoto[folderName] = false; // Выбрали одну картинку (есть подсвеченное фото)
    }
    
    // Клик на папку для загрузки фотографий:
    $('.b-list_folders-item').on('click', function(){
        
        var
            $this = $(this),
            $foldersContent = $('.b-folder-content'),
            $form = $('#load-folder-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            folderName = $(this).data('folder'),
            data = {
                folder: folderName
            };
            
        $foldersContent.hide();
       
        if ($('.b-folder-content[data-folder="' + folderName + '"]').length>0) {
            
            console.log('AAA отображаем');
            $('.b-folder-content[data-folder="' + folderName + '"]').show();
            MarkFolderSelected($this);
            
        } else {
            
            console.log('AAA подгружаем');
            
            StartLoading();
            
            $.ajax(action, {
                type: method,
                data: data,
                success: function(data) {
                    //console.log('AAA success', data);
                    StopLoading();
                    RenderFilesList(folderName, data);
                    MarkFolderSelected($this);
                },
                error: function(rew, status, err) {
                    console.log(status, err);                    
                }
            });
        }
       
       
        
        return false;
        
    });

    
    // Клик на фото:
    $foldersContentWrap.on('click', '.b-foto_inner', function(){
        
        var
            $this = $(this),
            num,
            $currentFolderWrap = $this.parents('.b-folder-content'),
            folderName = $currentFolderWrap.data('folder');
        
        console.log('AAA folderName ', folderName);
        
        /*
        freeNumbers.some(function(el) {
            currentNumToSelect = el;
            return ($('.b-foto_inner[data-num="' + el + '"]', $currentFolderWrap).length == 0);
        });
        */
        
        console.log('AAA currentNumToSelect ', currentNumToSelect);
        
        if (!$this.hasClass('selected'))
        {
            // Клик по фото без рамки
            
            if (!hasSelectedFoto[folderName]) {
                // выбор первого фото для пары:
                console.log('AAA 1-е фото в пару');
                num = currentNumToSelect[folderName];
                hasSelectedFoto[folderName] = true;
            } else {
                // выбор второго фото для пары (пара сформирована):
                console.log('AAA 2-е фото в пару');
                num = currentNumToSelect[folderName];
                
                $this.addClass('paired');
                $('.b-foto_inner[data-num="' + num + '"]', $currentFolderWrap).addClass('paired');
                
                freeNumbers.some(function(el) {
                    currentNumToSelect[folderName] = el;
                    return ($('.b-foto_inner[data-num="' + el + '"]', $currentFolderWrap).length == 0);
                });
                hasSelectedFoto[folderName] = false;
            }
            
            
            $('.b-foto_number', $this).text(num);
            $this.attr('data-num', num);
            $this.css('border-color', colorsActive[num]);
            $this.addClass('selected');
            
        }
        else
        {
            // Клик по фото с рамкой
            console.log('AAA убираем пару');
            
            var
                pairedNum = $this.attr('data-num'),
                $pairedFotos = $('.b-foto_inner[data-num="' + pairedNum + '"]', $currentFolderWrap),
                isFromPair = $this.hasClass('paired');
            
            $('.b-foto_number', $pairedFotos).text('');
            $pairedFotos.attr('data-num', '')
                        .removeClass('paired')
                        .removeClass('selected')
                        .css('border-color', '#8D9094');
            
            
            // Клик по фото из пары при выделеной одной фото из другой пары:
            if (!hasSelectedFoto[folderName] || !isFromPair) {
                hasSelectedFoto[folderName] = false;
            
                freeNumbers.some(function(el) {
                    currentNumToSelect[folderName] = el;
                    return ($('.b-foto_inner[data-num="' + el + '"]', $currentFolderWrap).length == 0);
                });
            }
            
        }
        
        
    });        

    // Клик на "Сохранить" для объявления:
    $('.btn.btn-primary.save-folders').on('click', function(){
        
        var
            $form = $('#save-folders-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            data = {
                type: 213
            };

            data.test = 123;
       
        console.log('AAA data = ', data);
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                console.log('AAA success', data);
                /*
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                }
                */
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
        
    });        
    

    // Отображаем содержимое первой папки при загрузке страницы:
    $('.b-list_folders-item').first().click();

});