<?php

use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'invokables' => [
            Zend\Expressive\Router\RouterInterface::class => Zend\Expressive\Router\ZendRouter::class,
        ],
        'factories' => [
            App\Action\Logout::class => function (ContainerInterface $container) {
                return new \App\Action\Logout(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Index::class => function (ContainerInterface $container) {
                return new App\Action\Index(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
        ],
    ],

    'routes' => [
        [
            'name' => 'home',
            'path' => '/[:lang/]',
            'middleware' => App\Action\Index::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'register',
            'path' => '/[:lang/]reg/',
            'middleware' => App\Action\User\Register::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'login',
            'path' => '/[:lang/]login/',
            'middleware' => App\Action\User\Login::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'logout',
            'path' => '/[:lang/]logout/',
            'middleware' => App\Action\Logout::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        
    ],
];
