<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'factories' => [
            App\Action\Admin\Login::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Login(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Logout::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Logout(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Profile::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Profile(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Index::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Index(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Main::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Main(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Init::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Init(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            
        ],
    ],

    'routes' => [
        [
            'name' => 'adm.index',
            'path' => '/[:lang/]support/',
            'middleware' => App\Action\Admin\Index::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.main.save',
            'path' => '/[:lang/]support/main/save/',
            'middleware' => App\Action\Admin\Main::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Main::SAVE_FOLDERS,
                ]
            ],
        ],
        [
            'name' => 'adm.main.loadfolder',
            'path' => '/[:lang/]support/main/loadfolder/',
            'middleware' => App\Action\Admin\Main::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Main::LOAD_FOLDER,
                ]
            ],
        ],
        [
            'name' => 'adm.main.loadfolderslist',
            'path' => '/[:lang/]support/main/loadfolderslist/',
            'middleware' => App\Action\Admin\Main::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Main::LOAD_FOLDERS_LIST,
                ]
            ],
        ],
        [
            'name' => 'adm.init',
            'path' => '/[:lang/]support/init/',
            'middleware' => App\Action\Admin\Init::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.login',
            'path' => '/[:lang/]support/login/',
            'middleware' => App\Action\Admin\Login::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.logout',
            'path' => '/[:lang/]support/logout/',
            'middleware' => App\Action\Admin\Logout::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],        
        [
            'name' => 'adm.pairs',
            'path' => '/[:lang/]support/pairs/',
            'middleware' => App\Action\Admin\Supports::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        
        [
            'name' => 'adm.profile',
            'path' => '/[:lang/]support/profile/',
            'middleware' => App\Action\Admin\Profile::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        
    ],
];
