<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Acl;


use App\Entity\User;
use App\Entity\Support;


/**
 * Class Roles
 * @package App\Acl
 */
class Roles
{
    
    const ROLE_ADMIN = Support::ROLE_ADMIN;
    
    /**
     *
     * @var array
     */
    protected $roles = [
        self::ROLE_ADMIN => self::ROLE_ADMIN,
    ];
    
    /**
     * 
     * @return array
     */
    public function getRoles() {
        return $this->roles;
    }
    
    /**
     * 
     * @param int $id
     * @return boolean|string
     */
    public function getRoleById($id) {
        if (array_key_exists($id, $this->roles)) {
            $result = $this->roles[$id];
        } else {
            $result = false;
        }
        return $result;
    }
}