<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use App\Action\Admin\Common;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Expressive\Template\TemplateRendererInterface;

use App\Authentication\SupportService;

/**
 * Class Index
 * @package App\Action\Admin
 */
class Index extends Common
{

    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        
        chdir('public/fotos');
        $dir  = getcwd();
        chdir('../..');
        $folders = scandir($dir);
        
        foreach ($folders as $key=>$folder_name) {
            if (strpos($folder_name, '.') > -1) {
                unset($folders[$key]);
            }
        }
        
        /** @var SupportService $auth */
        /*
        $auth = $this->container->get(SupportService::class);
        $role = $auth->getIdentity()->getRoleId();
        if (in_array($role, ['admin'])) {
        } else {
        }
        */
        

        $data = [
            'lang' => $request->getAttribute('layoutInfo')->getLang(),
            'colors_active' => $this->container->get('config')['foto_conf']['colors_active'],
            'pairs_count' => $this->container->get('config')['foto_conf']['pairs_count'],
            'folders' => $folders,
            'dir' => $dir,
        ];
        
        return new HtmlResponse($this->template->render('app::main', $data));
    }
}