<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Slim\Flash\Messages;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Diactoros\Response\RedirectResponse;
use Zend\Hydrator\DelegatingHydrator;


/**
 * Class SystemAction
 * @package App\Action\Admin
 */
class Main extends Common
{
    const SAVE_FOLDERS = 'save_folders';
    const LOAD_FOLDER = 'load_folder';
    
    
    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return HtmlResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        
        if($request->getMethod() == 'POST') {
            
            try {
                switch ($request->getAttribute('action')) {
                    case self::SAVE_FOLDERS:    
                        $response = $this->saveFolders($request);
                        break;
                    case self::LOAD_FOLDER:    
                        $response = $this->loadFolder($request);
                        break;
                    default:                    
                }
            } catch(\Exception $e) {
                $data = [
                    'result' => false,
                    'msg' => $e->getMessage(),                    
                ];
                $response = new JsonResponse($data);
            }                        
            return $response;            
        }
        
    }
    
    private function saveFolders(ServerRequestInterface $request)
    {
        $data = $request->getParsedBody();
        //return new JsonResponse($data);
        $folders_list = [];
        
        chdir('public/');
        
        foreach($data as $folder => $pairs) {
            
            
            
            $from = "fotos/$folder";
            $to = "fotos-arch/$folder";
            
            if (is_dir($from)) {
                // Копируем папку в директорию-архив:
                
                $folders_list[] = $folder;
                mkdir($to, 0777);
                chmod($to, 0777);
                
                $d = dir($from);
                while (false !== ($entry = $d->read()))
                {
                    if ($entry == "." || $entry == "..") continue;
                    
                    if ($pairs) {
                        $pair_num = '';
                        foreach ($pairs as $pair => $pair_files) {
                            if (in_array($entry, $pair_files)) {
                                $pair_num = $pair.'--';
                                break;
                            }
                        }
                        
                        //$folders_list[] = $folder;
                        copy("$from/$entry", "$to/$pair_num$entry");
                    } else {
                        copy("$from/$entry", "$to/$entry");
                    }
                    
                }
                $d->close();
                
                
                // Удаляем старую папку:
                $folders_list[] = $from;
                $includes = glob($from.'/*');
                foreach ($includes as $include) {
                    unlink($include);
                    
                }
                rmdir($from);
            }
            
        }
        
        chdir('..');
        
        return new JsonResponse($folders_list);
        
        
        // Сформировать тестовые данные для статистики по фидам:
        if ($data['feedTestData']) {
            return $this->renderFeedTestData($request);
        }
    }
    
    
    private function loadFolder(ServerRequestInterface $request)
    {
        $data = $request->getParsedBody();
        if ($data['folder']) {
            
            chdir('public/fotos/'.$data['folder']);
            $dir  = getcwd();
            chdir('../../..');
            $entries = scandir($dir);
            
            $formats = $this->container->get('config')['foto_conf']['formats'];
            
            $filelist = array();
            foreach($entries as $entry) {
                foreach($formats as $ext) {
                    if (strpos($entry, '.'.$ext) > 0) {
                        $filelist[] = $entry;
                    }
                }
            }
            
            $data = $filelist;
            $response = new JsonResponse($data);
            
            
        } else {
            $data = [
                'result' => false,
            ];
            $response = new JsonResponse($data);
        }
        return $response;
    }
    
}