<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Slim\Flash\Messages;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Diactoros\Response\RedirectResponse;
use Zend\Hydrator\DelegatingHydrator;


/**
 * Class SystemAction
 * @package App\Action\Admin
 */
class Main extends Common
{
    const SAVE_FOLDERS = 'save_folders';
    const LOAD_FOLDER = 'load_folder';
    const LOAD_FOLDERS_LIST = 'load_folders_list';
    
    
    
    
    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return HtmlResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        
        if($request->getMethod() == 'POST') {
            
            try {
                switch ($request->getAttribute('action')) {
                    case self::SAVE_FOLDERS:    
                        $response = $this->saveFolders($request);
                        break;
                    case self::LOAD_FOLDER:    
                        $response = $this->loadFolder($request);
                        break;
                    case self::LOAD_FOLDERS_LIST:    
                        //$response = $this->loadFoldersList($request);
                        $response = $this->getArchiveData($request);
                        break;
                    default:                    
                }
            } catch(\Exception $e) {
                $data = [
                    'result' => false,
                    'msg' => $e->getMessage(),                    
                ];
                $response = new JsonResponse($data);
            }                        
            return $response;            
        }
        
    }
    
    private function saveFolders(ServerRequestInterface $request)
    {
        $data = $request->getParsedBody();
        $folders_list = [];
        
        $unic = time();
        
        /*
        $resp = [
            'result' => true,
            'folders' => $folders_list,
        ];
        return new JsonResponse($resp);
        */
        
        chdir('public/');
        
        // Сохраняем в файл данные о состоянии архива:
        $file_name = "fotos.dat";
        $file_data = json_decode(file_get_contents($file_name), true);
        foreach($data as $folder => $pairs) {
            $data_folder = $pairs;
            if (is_array($pairs)) {
                $data_folder = [];
                foreach($pairs as $pair => $files) {
                    $data_folder[$pair] = [];
                    foreach($files as $file) {
                        $pieces = explode("-", $file);
                        $name = $pieces[count($pieces)-1];
                        $data_folder[$pair][] = 'a'.$unic.'-'.$name;
                    }
                }
            }
            $file_data[$folder] = $data_folder;
        }
        file_put_contents($file_name, json_encode($file_data));
        
        foreach($data as $folder => $pairs) {
            
            $from = "fotos/$folder";
            $to = "fotos-arch/$folder";
            
            // Переименовываем файлы внутри папки:
            if (is_dir($to)) {
                
                $d = dir($to);
                while (false !== ($entry = $d->read()))
                {
                    if ($entry == "." || $entry == "..") continue;
                    
                    $pieces = explode("-", $entry);
                    $name = $pieces[count($pieces)-1];
                    
                    rename("$to/$entry", "$to/a$unic-$name");
                }
                $d->close();
            }
            
            // Копируем папку в директорию-архив:
            if (is_dir($from)) {
                //$folders_list[] = $folder;
                
                mkdir($to, 0777);
                chmod($to, 0777);
                
                $d = dir($from);
                while (false !== ($entry = $d->read()))
                {
                    if ($entry == "." || $entry == "..") continue;
                    copy("$from/$entry", "$to/a$unic-$entry");
                }
                $d->close();
                
                // Удаляем старую папку:
                $folders_list[] = $from;
                $includes = glob($from.'/*');
                foreach ($includes as $include) {
                    unlink($include);
                    
                }
                rmdir($from);
            }
            
        }
        
        chdir('..');
        
        $resp = [
            'result' => true,
            //'folders' => $folders_list,
        ];
        return new JsonResponse($resp);
    }
        
    private function loadFolder(ServerRequestInterface $request)
    {
        $data = $request->getParsedBody();
        if ($data['folder'] && $data['type']) {
            
            if ($data['type'] == 'new') $folder = 'fotos';
            if ($data['type'] == 'arch') $folder = 'fotos-arch';
            
            chdir("public/$folder/".$data['folder']);
            $dir  = getcwd();
            chdir('../../..');
            $entries = scandir($dir);
            
            $formats = $this->container->get('config')['foto_conf']['formats'];
            
            $filelist = array();
            foreach($entries as $entry) {
                foreach($formats as $ext) {
                    if (strpos($entry, '.'.$ext) > 0) {
                        $filelist[] = $entry;
                    }
                }
            }
            
            $data = $filelist;
            $response = new JsonResponse($data);
            
        } else {
            $data = [
                'result' => false,
            ];
            $response = new JsonResponse($data);
        }
        return $response;
    }

    private function loadFoldersList(ServerRequestInterface $request)
    {
        $data = $request->getParsedBody();
        if ($data['type']) {
            
            if ($data['type'] == 'new') $folder = 'fotos';
            if ($data['type'] == 'arch') $folder = 'fotos-arch';
            
            if ($data['type'] == 'arch') {
                chdir('public/');
                $file_name = "fotos.dat";
                $archive_data = json_decode(file_get_contents($file_name), true);
                chdir('..');
            }
            
            
            chdir("public/$folder");
            $dir  = getcwd();
            chdir('../..');
            $folders = scandir($dir);

            foreach ($folders as $key=>$folder_name) {
                if (strpos($folder_name, '.') > -1) {
                    unset($folders[$key]);
                }
            }
            
            $resp = [
                'folders' => $folders,
                'archive' => $archive_data
            ];
            
            $response = new JsonResponse($resp);
        } else {
            $data = [
                'result' => false,
            ];
            $response = new JsonResponse($data);
        }
        return $response;
    }
    
    private function getArchiveData(ServerRequestInterface $request)
    {
        chdir('public/');
        $file_name = "fotos.dat";
        $archive_data = json_decode(file_get_contents($file_name), true);
        chdir('..');

        $resp = [
            'archive' => $archive_data
        ];

        return new JsonResponse($resp);
    }
    
}