package main

import (
	"fmt"
	"github.com/tarantool/go-tarantool"
	"time"
	"log"
	"strings"
	"os"
	_ "github.com/go-sql-driver/mysql"
	"github.com/jmoiron/sqlx"
	"encoding/json"
)

func GetTTConnn(url string) *tarantool.Connection {
	opts := tarantool.Opts{
		Reconnect: time.Second * 10,
	}
	parts := strings.SplitN(url, "@", 2)
	var addr string
	if len(parts) == 1 {
		addr = parts[0]
	} else {
		addr = parts[1]
		parts = strings.SplitN(parts[0], ":", 2)
		opts.User = parts[0]
		if len(parts) > 1 {
			opts.Pass = parts[1]
		}
	}
	ttConn, err := tarantool.Connect(addr, opts)
	if err != nil {
		log.Fatal(err)
	}
	return ttConn
}
func GetMySQLConn() *sqlx.DB {
	msConn, err := sqlx.Open("mysql", os.Getenv("MYSQL_URL"))
	if err == nil {
		err = msConn.Ping()
	}
	if err != nil {
		fmt.Println("MySQL connection error:", err)
		return nil
	}
	return msConn
}


func main() {
	if len(os.Args) < 2 {
		log.Fatal("Usage: tarantool_test url")
	}
	conn := GetTTConnn(os.Args[1])
	if conn == nil {
		log.Fatal("Tarantool connection error")
	}
	ms := GetMySQLConn()
	if ms == nil {
		log.Fatal("MySQL connection error")
	}

	fchan := make(chan *tarantool.Future, 100000)
	go func() {
		var rows []struct {
			ID uint32 `db:"id" json:"-"`
			CatID uint32 `json:"-"`
			URL string `json:"url"`
			Title string `json:"name"`
			Price float64 `json:"price"`
			Brand string `json:"vendor"`
			ImageURL float64 `json:"picture"`
			OldPrice float64 `json:"oldprice"`
			CurrencyID string `json:"currencyId"`
			Description string `json:"description"`
		}
		ms.Select(&rows,"SELECT ID,CatID,URL,Title,Price,Brand,ImageURL,OldPrice,CurrencyID,Description from goods")
fmt.Println("Got",len(rows), "rows")
		for _, row := range rows{
			bs, _ := json.Marshal(row)
			fchan <- conn.InsertAsync("retarg_goods", []interface{}{row.ID, row.CatID,string(bs)})
		}
		close(fchan)
	}()
	for f := range fchan {
		_, err := f.Get()
		if err != nil {
			log.Fatal(err)
		}
	}
}
